IF EXISTS(SELECT * 
		FROM SYS.SYSOBJECTS 
		WHERE NAME ='P_GERA_ANALISE_LEAD_TIME_EXECUTE_ALL' AND TYPE=N'P')
BEGIN
	DROP PROCEDURE P_GERA_ANALISE_LEAD_TIME_EXECUTE_ALL
END
GO
GO

SET ANSI_NULLS ON  
SET QUOTED_IDENTIFIER ON 
GO
CREATE PROCEDURE [dbo].[P_GERA_ANALISE_LEAD_TIME_EXECUTE_ALL] AS
DECLARE @CD_FABRIC INT
DECLARE @TP_PROC INT
SET NOCOUNT on;
PRINT 'Processamento lead time do fabricante ' 
DECLARE fabricante CURSOR FAST_FORWARD FOR 
											SELECT
												CD_FABRIC,
												0 AS TP_PROC
											FROM         
												EST_PROD_FABRIC
											WHERE     
												INDICADOR_SUPRIMENTO = 1
											UNION ALL
											SELECT
												CD_CTR_GRUPO,
												1 AS TP_PROC
											FROM         
												EST_PROD_FABRIC_GRUPO
											WHERE     
												INDICADOR_SUPRIMENTO = 1
OPEN fabricante
FETCH NEXT FROM fabricante INTO @CD_FABRIC,@TP_PROC
WHILE @@FETCH_STATUS=0
  begin
	PRINT	'  Analise fabricante ' + convert(varchar(5), @CD_FABRIC)+ ' tipo ' + convert(varchar(5), @TP_PROC) + 
			' (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...'
	EXECUTE P_GERA_ANALISE_LEAD_TIME @CD_FABRIC,@TP_PROC
	
	FETCH NEXT FROM fabricante INTO @CD_FABRIC,@TP_PROC
  end
PRINT 'Concludo.'
CLOSE fabricante
DEALLOCATE fabricante
